#include <AcceleroMMA7361.h> // accelerometer library
AcceleroMMA7361 accelero; // initialize library
unsigned long lastTime; // used to compare time
const unsigned long loop_time = 5; // how many times a second does it collect data ex. 50 equals every 50ms
boolean startup; // test w/ true or false
int x;  // x axis
int y;
int z;
int magnitude = 0;

int record = 0; // record the data
int bite_size = 0; //not use right now
int pushButton1 = 2; // button 1
int prevState1 = LOW; // comparer to state of button 1
int pushButton2 = 3;
int prevState2 = LOW;
int printer = 0; // does it send the data to serial monitor or not

int myStrings[700]={};
int counter = 0;
int total_values = 0;

int total_points = 700;
String sum;
String data_1;
String data_2;
String data_3;
String data_4;
String data_5;
String data_6;
String data_7;
String data_8;
String data_9;
String data_10;
String data_11;
String data_12;
String data_13;
String data_14;
String data_15;
String data_16;
String data_17;
String data_18;
String data_19;
String data_20;

void setup()
{
 Serial.begin(9600);
 accelero.begin(13, 12, 11, 10, A0, A1, A2); // pins used for accelerometer
 accelero.setARefVoltage(5); //sets the AREF voltage to 3.3V
 accelero.setSensitivity(LOW); //sets the sensitivity to +/-6G
 accelero.calibrate(); // calibrate the sensor
 sum = 0;
 pinMode(A5,OUTPUT); // pin A5 connected to LED
 pinMode(pushButton1, INPUT); // voltage increase when pins is pressed so pins detect HIGH or LOW
 pinMode(pushButton2, INPUT);
 pinMode(7,OUTPUT);
 delay(50);

}
void loop()
{
if(startup == false){ // has the startup function been run
startsup(); // blink A5 twice to signal that everything is ready and setup has completed
}
int currState1 = digitalRead(pushButton1); // read the state of push button 1
int currState2 = digitalRead(pushButton2);
if (currState1 != prevState1){
  record = record + 1; // add 1 to record
  delay(350); // wait until push is competed so it does not record change twice
}
if (currState2 != prevState2){ // test whether state of pushbutton has changed
  printer = printer + 1;
  delay(350);
}
if (record == 1){ 
  collect();
  digitalWrite(7,HIGH); // light up 7 to indicate that data is being collected
}
if (record == 2){ //set record back to 0 so that record does not go 3,4,5....
  record = 0;
  digitalWrite(7,LOW);// turn off indicator light
lastTime = millis() - loop_time; // make sure that lastTime keeps up with the time so that it does not record the entire time
}
if (record == 0){ 
  digitalWrite(7,LOW);
  lastTime = millis() - loop_time;
}
if (printer == 1){
  send_data();
}
if (printer == 2){
  printer = 0;
}
if (printer == 0 ){
  digitalWrite(A5,LOW);
}

} // end of main loop



void collect(){ // function that collects the data
if(millis() - lastTime > loop_time){ //has it been x ms and time to run loop agian
x = accelero.getXAccel(); // collect on x axis
y = accelero.getYAccel();
z = accelero.getZAccel();
magnitude = sqrt((x*x)+(y*y)+(z*z)); // magnitude of the 3 axis
if (counter <= total_points){
myStrings[counter] = magnitude;
counter = counter + 1;
total_values = total_values + 1;
}
else{
  counter = total_points;
  total_values = total_points;
}

lastTime += loop_time; // add time so that loop does not run forever
}
}

void startsup(){ // function that blinks A5 twice to signal everything is ready
digitalWrite(A5,HIGH);
delay(500);
digitalWrite(A5,LOW);
delay(500);
digitalWrite(A5,HIGH);
delay(500);
digitalWrite(A5,LOW);
startup = true;
}

void send_data(){ // function to send the data
delay(100);
digitalWrite(A5,HIGH);
Serial.print("Here it is:  "); // start of data
for (counter = 0; counter < total_values; counter = counter + 1) {
  Serial.println(myStrings[counter]);
}
Serial.println("# of Data points:");
Serial.println(total_values);
delay(100);
digitalWrite(A5,LOW);
printer = 0; // reset all values meanin all data wiped and ready to run agian
sum = 0;
magnitude = 0;
counter = 0;
total_values = 0;
}
